<?php
/**
 * @version   0.7.0
 * @author    Richard Eisenmenger
 * @copyright Copyright (C) 2015 Richard Eisenmenger
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */

// no direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

class plgSystemJhsplashscreen extends JPlugin
{
    public function plgSystemJhsplashscreen(&$subject, $params)
    {
        parent::__construct($subject, $params);
    }

    public function onAfterRender()
    {
        // Get all parameters from the plugin configuration
        $targetGroup = $this->params->get('access', 0);
        $delay = intval($this->params->get('delay', 0)) * 1000;
        $popupTechnology = $this->params->get('popupTechnology', 0);
        $popupWidth = $this->params->get('popupWidth', '600');
        $popupHeight = $this->params->get('popupHeight', '450'); 
        $popupBackgroundColor = $this->params->get('popupBackgroundColor', '#ffffff'); 
        $listSplashScreens = $this->params->get('listSplashScreens', 0);
        $splashScreenArray = json_decode($listSplashScreens, true);
        $configurationMode = $this->params->get('configurationMode', 0);
        $html = '';

        // Get the current page content to manipulate it later
        $app = JFactory::getApplication();
        $body = $app->getBody();

        // Get the user's access level to figure out whether to show the splash screen
        $user = JFactory::getUser();
        $groups = $user->getAuthorisedViewLevels();
        if (array_search($targetGroup, $groups) === false)
        {
            return;
        }

        // Figure out what the currently displayed page is
        $menus = $app->getMenu();
        $menu = $menus->getActive();
        if ($menu)
        {
            $currentPage = $menu->id;
        }
        else
        {
            return;
        }

        // Find that page in the splash screen list
        $position = array_search($currentPage, $splashScreenArray['targetMenuItem']);

        // Proceed only if the current page was found in the splash screen list and we are in the frontend
        if (($position !== false) && ($app->isSite()))
        {
            // If we are in configuration mode, set the user's cookie to "The splash screen was not shown yet"
            if ($configurationMode == '0')
            {
                $app->setUserState('jh_splash_screen_' . $position . '_shown','false');
            }

            // Proceed only if the splash screen was not shown yet
            if ($app->getUserState('jh_splash_screen_' . $position . '_shown','false') == 'false')
            {
                if ($splashScreenArray['contentArticle'][$position] != 'none')
                {
                    $table= JTable::getInstance('Content', 'JTable');
                    $table->load($splashScreenArray['contentArticle'][$position]);
                    $contentHtml = $table->introtext;
                } else {
                    $contentHtml = $splashScreenArray['splashContent'][$position];
                }

                switch ($popupTechnology)
                {
                    case '1':
                        /* Joomla MooTools SqueezeBox */
                        $html .= '<style>#sbox-window,#sbox-content { background-color: ' . $popupBackgroundColor . ';}</style>';
                        $html .= '<div style="display:none;"><div id="jh_splash_screen_content">' . $contentHtml . '</div></div>';
                        $html .= '<script> jQuery( document ).ready(function() { SqueezeBox.initialize(); setTimeout(function() { SqueezeBox.open($("jh_splash_screen_content"), { handler: "adopt", size: {x: ' . $popupWidth . ', y: ' . $popupHeight . '}}); }, ' . $delay . '); });</script>';
                        break;
                    case '3':
                        /* Future: lightbox2 */
                        break;
                    case '4':
                        /* Magnific Popup */
                        $html .= '<div id="jh_splash_screen_content" class="mfp-hide magnific_popup" style="position: relative;   background-color: ' . $popupBackgroundColor . '; padding: 20px; width: ' . $popupWidth . 'px; max-width: ' . $popupWidth . '; height: ' . $popupHeight . 'px; margin: 20px auto;">' . $contentHtml . '</div>';
                        $html .= '<script> jQuery( document ).ready(function() { ';
                        $html .= 'setTimeout(function() { jQuery.magnificPopup.open({ items: { src: \'#jh_splash_screen_content\', type: \'inline\' } }); }, ' . $delay . ');';
                        $html .= '});</script>';
                        break;
                }



                // Inject splash screen markup
                $body = str_replace('</body>', $html . '</body>', $body);
                $app->setBody($body);

                // Now that the splash screen was shown, mark that in the cookie
                if ($configurationMode == '1') 
                {
                    $app->setUserState('jh_splash_screen_' . $position . '_shown','true');
                }
            }
        }
        return true;
    }

    public function onBeforeCompileHead()
    {
        // Get all parameters from the plugin configuration
        $targetGroup = $this->params->get('access', 0);
        $popupTechnology = $this->params->get('popupTechnology', 0);
        $listSplashScreens = $this->params->get('listSplashScreens', 0);
        $splashScreenArray = json_decode($listSplashScreens, true);
        $configurationMode = $this->params->get('configurationMode', 0);

        $app = JFactory::getApplication();

        $user = JFactory::getUser();
        $groups = $user->getAuthorisedViewLevels();
        if (array_search($targetGroup, $groups) === false)
        {
            return;
        }

        // Figure out what the currently displayed page is
        $menus = $app->getMenu();
        $menu = $menus->getActive();
        if ($menu)
        {
            $currentPage = $menu->id;
        }
        else
        {
            return;
        }

        // Find that page in the splash screen list
        $position = array_search($currentPage, $splashScreenArray['targetMenuItem']);
        
        // Proceed only if we are in the frontend 
        if (($position !== false) && ($app->isSite()))
        {
            JHtml::_('jquery.framework');
            JHtml::_('bootstrap.framework');

            // If we are in configuration mode, set the user's cookie to "The splash screen was not shown yet"
            if ($configurationMode == '0')
            {
                $app->setUserState('jh_splash_screen_' . $position . '_shown','false');
            }

            if ($app->getUserState('jh_splash_screen_' . $position . '_shown','false') == 'false')
            {  
                switch ($popupTechnology)
                {
                    case '1':
                        /* Joomla MooTools SqueezeBox */
                        JHtml::_('behavior.modal');
                        break;
                    case '3':
                        /* Future: lightbox2 */
                        //$doc =& JFactory::getDocument();
                        //$doc->addScript('//cdnjs.cloudflare.com/ajax/libs/lightbox2/2.7.1/js/lightbox.min.js');
                        //$doc->addStyleSheet('//cdnjs.cloudflare.com/ajax/libs/lightbox2/2.7.1/css/lightbox.css');
                        break;
                    case '4':
                        /* Magnific Popup */
                        $doc =& JFactory::getDocument();
                        $doc->addScript('//cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.0.0/jquery.magnific-popup.min.js');
                        $doc->addStyleSheet('//cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.0.0/magnific-popup.min.css');
                        break;
                }
            }
        }
    }
}