<?php
/**
 * @package   AllediaFreeDefaultFiles
 * @contact   www.alledia.com, hello@alledia.com
 * @copyright 2015 Alledia.com, All rights reserved
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die('Restricted access');

JFormHelper::loadFieldClass('list');
JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_content/models', 'ContentModel');

/**
 * Form field to show an advertisement for the pro version
 */
class JFormFieldArticleList extends JFormFieldList
{
    protected function getOptions()
    {

        $model = JModelLegacy::getInstance('Articles', 'ContentModel', array('ignore_request' => true));

        // Set List SELECT
        $model->setState('list.select', 'a.id, a.title');
        $model->setState('filter.published', 1);
        // Set Ordering filter
        $model->setState('list.ordering', 'a.title');
        $model->setState('list.direction', 'ASC');

        $items = $model->getItems();

        if ($error = $model->getError())
        {
            JError::raiseError(500, $error);

            return false;
        }

        // Build the options list

        $options = array();
        $options[] = JHtml::_('select.option', 'none', '– None –');
        foreach ($items as &$item)
        {
            $options[] = JHtml::_('select.option', $item->id, '' . $item->id . ': ' . $item->title);
        }

        //$html = 'Das ist ein Test';

        return $options;
    }
}
