<?php
/**
* ChronoCMS version 1.0
* Copyright (c) 2012 ChronoCMS.com, All rights reserved.
* Author: (ChronoCMS.com Team)
* license: Please read LICENSE.txt
* Visit http://www.ChronoCMS.com for regular updates and information.
**/
namespace GCore\Extensions\Chronoforums\Helpers;
/* @copyright:ChronoEngine.com @license:GPLv2 */defined('_JEXEC') or die('Restricted access');
defined("GCORE_SITE") or die;
class TopicTasks {
	var $view;

	function tasks_list($topic = array()){
		//echo '<form action="'.r_('index.php?option=com_chronoforums&cont=topics').'" method="post" name="searchform">';
		echo '<span class="input-group-addon">'.l_('CHRONOFORUMS_QUICK_TASKS').'</span>';
		$options = array(
			'' => ' - ',
			'delete' => l_('CHRONOFORUMS_DELETE_TOPIC'),
			//'delete_author' => l_('CHRONOFORUMS_DELETE_AUTHOR'),
		);

		if((bool)$this->view->vars['fparams']->get('allow_author_delete', 1) === true){
			$options['delete_author'] = l_('CHRONOFORUMS_DELETE_AUTHOR');
		}

		if(empty($topic['locked'])){
			$options['lock'] = l_('CHRONOFORUMS_LOCK_TOPIC');
		}
		if(!empty($topic['locked']) OR empty($topic)){
			$options['unlock'] = l_('CHRONOFORUMS_UNLOCK_TOPIC');
		}
		if(empty($topic['announce'])){
			$options['announce'] = l_('CHRONOFORUMS_SET_ANNOUNCEMENT');
		}
		if(!empty($topic['announce']) OR empty($topic)){
			$options['unannounce'] = l_('CHRONOFORUMS_UNSET_ANNOUNCEMENT');
		}
		if(empty($topic['sticky'])){
			$options['sticky'] = l_('CHRONOFORUMS_SET_STICKY');
		}
		if(!empty($topic['sticky']) OR empty($topic)){
			$options['unsticky'] = l_('CHRONOFORUMS_UNSET_STICKY');
		}

		if(empty($topic['published'])){
			$options['publish'] = l_('CHRONOFORUMS_PUBLISH_TOPIC');
		}
		if(!empty($topic['published']) OR empty($topic)){
			$options['unpublish'] = l_('CHRONOFORUMS_UNPUBLISH_TOPIC');
		}

		echo \GCore\Helpers\Html::input('act', array('type' => 'dropdown', 'label' => '', 'class' => 'form-control', 'options' => $options));
		echo \GCore\Helpers\Html::input('f', array('type' => 'hidden', 'value' => isset($topic['forum_id']) ? $topic['forum_id'] : ''));
		echo \GCore\Helpers\Html::input('t', array('type' => 'hidden', 'value' => isset($topic['id']) ? $topic['id'] : ''));
		echo '<span class="input-group-btn">';
		echo '<input type="submit" name="topic_tasks_process" class="btn btn-warning" value="'.l_('CHRONOFORUMS_GO').'">';
		echo '</span>';
		//echo '</form>';
	}

	function tasks_form($topic = array()){
		if(!is_null($topic) AND \GCore\Libs\Authorize::authorized('\GCore\Extensions\Chronoforums\Chronoforums', 'modify_topics')){
			echo '<form action="'.r_('index.php?option=com_chronoforums&cont=topics').'" method="post" name="topictasksform" class="form-inline">';
			echo '<div class="input-group input-group-sm">';
			$this->tasks_list(!empty($topic['Topic']) ? $topic['Topic'] : array());
			echo '</div>';
			echo '</form>';
		}
	}

	function tags_input($topic = array(), $tags = array()){
		if(!empty($tags)){
			//$options = array('' => '');
			foreach($tags as $tag){
				$options[$tag['Tag']['id']] = $tag['Tag']['title'];
			}
			//$values = \GCore\Libs\Arr::getVal($topic, array('Tag', '[n]', 'id'), array());
			$values = array();
			if(!empty($topic['Tag'])){
				foreach($topic['Tag'] as $k => $tag){
					$values[] = array('id' => $tag['id'], 'text' => $tag['title']);	
				}
			}
			$doc = \GCore\Libs\Document::getInstance();
			/*$doc->addJsFile(\GCore\C::get('GCORE_FRONT_URL').'extensions/chronoforums/assets/chosen/chosen.jquery.min.js');
			$doc->addCssFile(\GCore\C::get('GCORE_FRONT_URL').'extensions/chronoforums/assets/chosen/chosen.min.css');
			$doc->addJsCode('
				jQuery(document).ready(function($){
					$("#topic_tags").chosen({no_results_text:"'.l_('CHRONOFORUMS_TAGS_NO_RESULTS').'"});
				});
			');*/
			$doc->_('select2');
			$doc->addJsCode('jQuery(document).ready(function($){ $("#topic_tags").select2(
				{
					minimumInputLength: 1,
					containerCss:{"max-width":"200px"},
					//width: "resolve",
					multiple: true,
					tags: true,
					tokenSeparators: [","," "],
					ajax:{
						url: "'.r_('index.php?option=com_chronoforums&cont=topics&act=tags_lookup&tvout=ajax').'",
						dataType: "json",
						data: function (term, page){
							return {
								tag_q: term,
							};
						},
						results: function (data, page){
							return {results: data};
						}
					},
					initSelection: function(element, callback){
						var data = '.json_encode($values).';
						callback(data);
					}
				}
			);
			$("#topic_tags").select2("data", '.json_encode($values).');
			});');
			//echo \GCore\Helpers\Html::formStart('cfu-topic-tags');
			//echo \GCore\Helpers\Html::formSecStart();
			//echo \GCore\Helpers\Html::input('topic_tags[]', array('type' => 'dropdown', ':data-placeholder' => l_('CHRONOFORUMS_TOPIC_TAGS'), 'id' => 'topic_tags', 'multiple' => 'multiple', 'options' => $options, 'values' => $values, 'class' => 'form-control'));
			echo \GCore\Helpers\Html::input('topic_tags', array('type' => 'hidden', ':data-placeholder' => l_('CHRONOFORUMS_TOPIC_TAGS'), 'id' => 'topic_tags', 'multiple' => 'multiple', 'value' => ''));
			echo \GCore\Helpers\Html::input('act', array('type' => 'hidden', 'value' => 'tag_topic'));
			echo \GCore\Helpers\Html::input('f', array('type' => 'hidden', 'value' => isset($topic['Topic']['forum_id']) ? $topic['Topic']['forum_id'] : ''));
			echo \GCore\Helpers\Html::input('t', array('type' => 'hidden', 'value' => isset($topic['Topic']['id']) ? $topic['Topic']['id'] : ''));
			echo '<span class="input-group-btn">';
			echo '<input type="submit" name="topic_tasks_process" class="btn btn-warning btn-sm" value="'.l_('CHRONOFORUMS_UPDATE_TAGS').'">';
			echo '</span>';
			//echo \GCore\Helpers\Html::formSecEnd();
			//echo \GCore\Helpers\Html::formEnd();
		}
	}

	function tags_form($topic = array(), $tags = array()){
		$fparams = $this->view->vars['fparams'];
		if((((bool)$fparams->get('enable_topic_tags', 0) === true) OR ($fparams->get('search_method', 'deep') == 'tags')) AND \GCore\Libs\Authorize::authorized('\GCore\Extensions\Chronoforums\Chronoforums', 'modify_topics')):
		?>
		<form action="<?php echo r_('index.php?option=com_chronoforums&cont=topics'); ?>" method="post" name="topictagsform">
			<div class="input-group input-group-sm1 text-right">
				<?php $this->tags_input($topic, $tags); ?>
			</div>
		</form>
		<?php
		endif;
	}

	function tags_list($topic = array()){
		if(!empty($topic['Tag'])){
			$tags = \GCore\Libs\Arr::getVal($topic, array('Tag', '[n]', 'title'), array());
			foreach($tags as $tag){
				echo '<a class="cfu-tag cfu-tag-'.$tag.' btn btn-info btn-xs" href="'.r_('index.php?option=com_chronoforums&cont=forums&skeywords='.$tag).'"><span class=""><i class="fa fa-tag fa-lg fa-fw"></i>'.$tag.'</span></a>';
			}
		}
	}
	
	function quick_reply(){
		$fparams = $this->view->vars['fparams'];
		if($fparams->get('enable_quick_reply', 0) AND \GCore\Libs\Authorize::authorized('\GCore\Extensions\Chronoforums\Chronoforums', 'make_posts') === true):
		$doc = \GCore\Libs\Document::getInstance();
		$doc->addJsCode("
			var bbcode_area_id = 'quick_reply';
			var bbcode = new Array();
			var bbtags = new Array('[b]','[/b]','[i]','[/i]','[u]','[/u]','[quote]','[/quote]','[code]','[/code]','[list]','[/list]','[list=]','[/list]','[img]','[/img]','[url]','[/url]','[flash=]', '[/flash]','[size=]','[/size]');
		");
		$doc->addJsFile(\GCore\C::get('GCORE_FRONT_URL').'extensions/chronoforums/assets/js/editor.js');
		//$doc->addJsFile(\GCore\C::get('GCORE_FRONT_URL').'extensions/chronoforums/assets/js/quick_editor.js');
		/*$doc->addJsCode('
			jQuery(document).ready(function($){
				$(".editor_button").on("click", function(){
					$("#quick_reply").insertAtCaret($(this).data("code-start"), $(this).data("code-end"));
				});
			});
		');*/
		
		?>
		<form action="<?php echo r_('index.php?option=com_chronoforums&cont=posts&act=reply'); ?>" method="post" name="quick_reply_form" id="quick_reply_form">
			<div class="panel panel-default">
				<div class="panel-heading">
					<h3 class="panel-title pull-left"><?php echo l_('CHRONOFORUMS_QUICK_REPLY'); ?></h3>
					<span class="pull-right">
						<a title="<?php echo l_('CHRONOFORUMS_BOLD_TEXT'); ?>: [b]text[/b]" onclick="bbstyle(0); return false;" name="addbbcode0" accesskey="b" class="btn btn-default btn-sm"><i class="fa fa-bold fa-fw fa-lg"></i></a>
						<a title="<?php echo l_('CHRONOFORUMS_ITALIC_TEXT'); ?>: [i]text[/i]" onclick="bbstyle(2); return false;" name="addbbcode2" accesskey="i" class="btn btn-default btn-sm"><i class="fa fa-italic fa-fw fa-lg"></i></a>
						<a title="<?php echo l_('CHRONOFORUMS_UNDERLINE_TEXT'); ?>: [u]text[/u]" onclick="bbstyle(4); return false;" name="addbbcode4" accesskey="u" class="btn btn-default btn-sm"><i class="fa fa-underline fa-fw fa-lg"></i></a>
						<a title="<?php echo l_('CHRONOFORUMS_QUOTE_TEXT'); ?>: [quote]text[/quote]" onclick="bbstyle(6); return false;" name="addbbcode6" accesskey="q" class="btn btn-default btn-sm"><i class="fa fa-quote-left fa-fw fa-lg"></i></a>
						<a title="<?php echo l_('CHRONOFORUMS_CODE_DISPLAY'); ?>: [code]code[/code]" onclick="bbstyle(8); return false;" name="addbbcode8" accesskey="c" class="btn btn-default btn-sm"><i class="fa fa-code fa-fw fa-lg"></i></a>
						<a title="<?php echo l_('CHRONOFORUMS_INSERT_URL'); ?>: [url]http://url[/url] or [url=http://url]URL text[/url]" onclick="bbstyle(16); return false;" name="addbbcode16" accesskey="w" class="btn btn-default btn-sm"><i class="fa fa-link fa-fw fa-lg"></i></a>
						
					</span>
					<div class="clearfix"></div>
				</div>
				<div class="panel-body">
					<?php echo \GCore\Helpers\Html::input('Post[text]', array('type' => 'textarea', 'id' => 'quick_reply', 'class' => 'F', 'rows' => 5, 'cols' => 60, 'style' => 'width:100% !important;')); ?>
				</div>
				<div class="panel-footer text-center">
					<?php echo \GCore\Helpers\Html::input('quick_reply_submit', array('type' => 'submit', 'value' => l_('CHRONOFORUMS_SUBMIT'), 'class' => 'btn btn-success btn-sm')); ?>
				</div>
			</div>
			<?php echo \GCore\Helpers\Html::input('f', array('type' => 'hidden', 'value' => \GCore\Libs\Request::data('f'))); ?>
			<?php echo \GCore\Helpers\Html::input('t', array('type' => 'hidden', 'value' => \GCore\Libs\Request::data('t'))); ?>
		</form>
		<?php
		endif;
	}

	function no_posts(){
		?>
		<div class="panel panel-danger">
			<div class="panel-heading">
				<h3 class="panel-title"><?php echo l_('CHRONOFORUMS_INFORMATION'); ?></h3>
			</div>
			<div class="panel-body">
				<?php if(isset($this->view->vars['offline_message'])): ?>
				<p><?php echo $this->view->vars['offline_message']; ?></p>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

	function no_topics(){
		?>
		<div class="panel panel-danger">
			<div class="panel-heading">
				<h3 class="panel-title"><?php echo l_('CHRONOFORUMS_INFORMATION'); ?></h3>
			</div>
			<div class="panel-body">
				<?php if(isset($this->view->vars['offline_message'])): ?>
				<p><?php echo $this->view->vars['offline_message']; ?></p>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

	function reply_button($topic = array()){
		$fparams = $this->view->vars['fparams'];
		?>
		<?php if(empty($topic['Topic']['locked'])): ?>
			<?php if((bool)$fparams->get('hide_post_reply_button', 0) === false OR \GCore\Libs\Authorize::authorized('\GCore\Extensions\Chronoforums\Chronoforums', 'make_posts') === true): ?>
				<a title="<?php echo l_('CHRONOFORUMS_POST_REPLY'); ?>" class="btn btn-primary btn-sm" href="<?php echo r_('index.php?option=com_chronoforums&cont=posts&act=reply&f='.$topic['Forum']['id'].'&t='.$topic['Topic']['id']); ?>"><i class="fa fa-fw fa-reply"></i> <?php echo l_('CHRONOFORUMS_REPLY'); ?></a>
			<?php endif; ?>
		<?php endif; ?>
		<?php
	}

	function new_topic_button($forum = array()){
		$fparams = $this->view->vars['fparams'];
		?>
		<?php if((bool)$fparams->get('hide_new_topic_button', 0) === false OR \GCore\Libs\Authorize::authorized('\GCore\Extensions\Chronoforums\Chronoforums', 'make_topics') === true): ?>
			<a class="btn btn-primary btn-sm" href="<?php echo r_('index.php?option=com_chronoforums&cont=topics&act=add'.(!empty($forum['Forum']['id']) ? '&f='.$forum['Forum']['id'] : '')); ?>"><?php echo l_('CHRONOFORUMS_NEW_TOPIC'); ?></a>
		<?php endif; ?>
		<?php
	}
	
	function favorite_button($topic = array()){
		$user = \GCore\Libs\Base::getUser();
		$fparams = $this->view->vars['fparams'];
		if((bool)$fparams->get('enable_topics_favorites', 0) AND !empty($user['id'])):
		$class = ' fa-star-o';
		$title = l_('CHRONOFORUMS_ADD_TO_FAVORITES');
		$act = 'favorite';
		if(!empty($topic['Favorite']['topic_id'])){
			$class = ' fa-star cfu-favorited';
			$title = l_('CHRONOFORUMS_REMOVE_FROM_FAVORITES');
			$act = 'unfavorite';
		}
		?>
		<a title="<?php echo $title; ?>" class="btn btn-default btn-xs gcoreTooltip" href="<?php echo r_('index.php?option=com_chronoforums&cont=topics&act='.$act.'&f='.$topic['Forum']['id'].'&t='.$topic['Topic']['id']); ?>"><i class="fa fa-fw fa-2x<?php echo $class; ?>"></i></a>
		<?php
		endif;
	}

	function forum_title($forum = array()){
		?>
		<a class="cfu-title" href="<?php echo r_('index.php?option=com_chronoforums&cont=forums&f='.$forum['Forum']['id'].'&alias='.$forum['Forum']['alias']); ?>"><?php echo $forum['Forum']['title']; ?></a>
		<?php
	}

	function search_title(){
		$searched = !empty($this->view->vars['searched']) ? $this->view->vars['searched'] : '';
		$forum = !empty($this->view->vars['forum']) ? $this->view->vars['forum'] : array();
		$fparams = $this->view->vars['fparams'];
		$url = r_('index.php?option=com_chronoforums&cont=forums'.(!empty($forum) ? '&f='.$forum['Forum']['id'] : ''));
		if(\GCore\Libs\Request::data('search_age')){
			$search_age = \GCore\Libs\Request::data('search_age');
		}else{
			$search_age = $fparams->get('search_start_from_value', '1y');
		}
		if(!empty($forum)){
			$url = \GCore\Libs\Url::buildQuery($url, array('keywords' => $searched));
		}else{
			$url = \GCore\Libs\Url::buildQuery($url, array('skeywords' => $searched, 'search_age' => $search_age));
		}
		?>
		<?php echo sprintf(l_('CHRONOFORUMS_SEARCH_FOUND'), $this->view->Paginator->total); ?> <a class="cfu-title" href="<?php echo $url; ?>"><?php echo $searched; ?></a>
		<?php
	}

	function paginator($type = ''){
		$this->view->Paginator->bs();
		?>
		<?php if($type == 'info' OR empty($type)): ?>
		<div class="cfu-info pull-right">
			<?php echo $this->view->Paginator->getInfo(array('PAGINATOR_INFO' => l_('CHRONOFORUMS_PAGINATOR_INFO'))); ?>
		</div>
		<?php endif; ?>
		<?php if($type == 'data' OR empty($type)): ?>
			<?php echo $this->view->Paginator->getNav(array('PAGINATOR_PREV' => l_('CHRONOFORUMS_PAGINATOR_PREV'), 'PAGINATOR_FIRST' => l_('CHRONOFORUMS_PAGINATOR_FIRST'), 'PAGINATOR_LAST' => l_('CHRONOFORUMS_PAGINATOR_LAST'), 'PAGINATOR_NEXT' => l_('CHRONOFORUMS_PAGINATOR_NEXT'))); ?>
		<?php endif; ?>
		<?php
	}

	function search_form($forum = array()){
		?>
		<form action="<?php echo r_('index.php?option=com_chronoforums&cont=forums&f='.$forum['Forum']['id']); ?>" method="post" name="searchform">
			<div class="input-group input-group-sm">
				<input type="hidden" name="f" value="<?php echo $forum['Forum']['id']; ?>"/>
				<input type="text" class="form-control" value="" size="20" id="cfu-search_keywords" name="keywords" placeholder="<?php echo l_('CHRONOFORUMS_SEARCH_FORUM'); ?>..." />
				<span class="input-group-btn">
					<button class="btn btn-default" name="search_posts" type="submit" value=""><i class="fa fa-search"></i></button>
					<button class="btn btn-default reset" name="reset" type="submit" value=""><i class="fa fa-times"></i></button>
				</span>
			</div>
		</form>
		<?php
	}

	function attachments_icon($topic = array()){
		$fparams = $this->view->vars['fparams'];
		?>
		<?php if(!empty($topic['Topic']['has_attachments'])): ?>
		<i class="gcoreTooltip fa fa-paperclip" title="<?php echo l_('CHRONOFORUMS_HAS_ATTACHMENTS'); ?>"></i>
		<?php endif; ?>
		<?php
	}
	
	function datetime_icon($topic = array()){
		$fparams = $this->view->vars['fparams'];
		?>
		<i class="gcoreTooltip fa fa-calendar" title="<?php echo $this->view->Output->date_time($topic['Topic']['created']); ?>"></i>
		<?php
	}

	function unpublished_icon($topic = array()){
		$fparams = $this->view->vars['fparams'];
		?>
		<?php if(\GCore\Libs\Authorize::authorized('\GCore\Extensions\Chronoforums\Chronoforums', 'modify_topics') AND empty($topic['Topic']['published'])): ?>
		<img width="16" height="14" title="<?php echo l_('CHRONOFORUMS_TOPIC_NOT_APPROVED'); ?>" alt="<?php echo l_('CHRONOFORUMS_TOPIC_NOT_APPROVED'); ?>" src="<?php echo \GCore\C::get('GCORE_FRONT_URL').'extensions/chronoforums/styles/'.$fparams->get('theme', 'prosilver').'/imageset/icon_topic_unapproved.gif'; ?>">
		<?php endif; ?>
		<?php
	}

	function reported_icon($topic = array()){
		$fparams = $this->view->vars['fparams'];
		?>
		<?php if(!empty($topic['Topic']['reported'])): ?>
		<img width="16" height="14" title="<?php echo l_('CHRONOFORUMS_TOPIC_REPORTED'); ?>" alt="<?php echo l_('CHRONOFORUMS_TOPIC_REPORTED'); ?>" src="<?php echo \GCore\C::get('GCORE_FRONT_URL').'extensions/chronoforums/styles/'.$fparams->get('theme', 'prosilver').'/imageset/icon_topic_reported.gif'; ?>">
		<?php endif; ?>
		<?php
	}

	function row_title($topic = array()){
		$searched = !empty($this->view->vars['searched']) ? $this->view->vars['searched'] : '';
		$read = $this->is_topic_read($topic);
		echo $this->read_status($topic, $read);
		$class = ' cfu-unread';
		if($read === true){
			$class = ' cfu-read';
		}
		$url = r_('index.php?option=com_chronoforums&cont=posts&f='.$topic['Topic']['forum_id'].'&t='.$topic['Topic']['id'].'&alias='.$topic['Topic']['alias']);
		if(!empty($searched)){
			$url = \GCore\Libs\Url::buildQuery($url, array('hilit' => $searched));
		}
		?>
		<a href="<?php echo $url; ?>" class="cfu-title<?php echo $class; ?>"><?php echo strip_tags($topic['Topic']['title']); ?></a>
		<?php
	}
	
	function is_topic_read($topic = array()){
		$user = \GCore\Libs\Base::getUser();
		$fparams = $this->view->vars['fparams'];
		$uprofile = $this->view->vars['uprofile'];
		$read = null;
		//track topic read status
		if($uprofile->get('Profile.params.preferences.enable_topics_track', 0)){
			if(!empty($user['id']) AND (bool)$fparams->get('enable_topics_track', 0) === true){
				$read = false;
				if(!empty($topic['TopicTrack']['last_visit'])){
					$read = true;
					if(!empty($topic['LastPost']['created']) AND $topic['LastPost']['created'] > $topic['TopicTrack']['last_visit']){
						$read = false;
					}
				}else{
					if(!empty($topic['LastPost']['user_id']) AND $topic['LastPost']['user_id'] == $user['id']){
						$read = true;
					}
				}
			}
		}
		return $read;
	}
	
	function read_status($topic = array(), $read = null){
		if(is_null($read)){
			return '';//$read = $this->is_topic_read($topic);
		}
		if($read){
			return '<i class="fa fa-folder-open-o gcoreTooltip" title="'.l_('CHRONOFORUMS_NO_NEW_POSTS').'"></i>';
		}else{
			return '<i class="fa fa-folder-o gcoreTooltip" title="'.l_('CHRONOFORUMS_HAS_NEW_POSTS').'"></i>';
		}
	}

	function topic_title($topic = array()){
		?>
		<a class="cfu-title" href="<?php echo r_('index.php?option=com_chronoforums&cont=posts&f='.$topic['Forum']['id'].'&t='.$topic['Topic']['id'].'&alias='.$topic['Topic']['alias']); ?>"><?php echo strip_tags($topic['Topic']['title']); ?></a>
		<?php
	}

	function selector($topic = array()){
		echo $this->view->Html->input('topics_ids['.$topic['Topic']['id'].']', array('type' => 'checkbox', 'value' => 1));
	}

	function topic_category($topic = array()){
		?>
		<a class="cfu-category-title" href="<?php echo r_('index.php?option=com_chronoforums&c='.$topic['Category']['id']); ?>"><?php echo $topic['Category']['title']; ?></a>
		<?php
	}

	function topic_forum($topic = array()){
		?>
		<a class="cfu-forum-title" href="<?php echo r_('index.php?option=com_chronoforums&cont=forums&f='.$topic['Forum']['id'].'&alias='.$topic['Forum']['alias']); ?>"><?php echo $topic['Forum']['title']; ?></a>
		<?php
	}

	function status($topic = array()){
		$fparams = $this->view->vars['fparams'];
		$days = (time() - strtotime($topic['Topic']['created']))/(24*60*60);
		?>
		<?php if(!empty($topic['Topic']['announce'])): ?>
		<span class="label label-primary"><?php echo l_('CHRONOFORUMS_ANNOUNCEMENT'); ?></span>
		<?php endif; ?>
		<?php if(!empty($topic['Topic']['locked'])): ?>
		<span class="label label-default" style="background-color:#424242;"><?php echo l_('CHRONOFORUMS_LOCKED'); ?></span>
		<?php endif; ?>
		<?php if(!empty($topic['Topic']['sticky'])): ?>
		<span class="label label-info"><?php echo l_('CHRONOFORUMS_STICKY'); ?></span>
		<?php endif; ?>
		<?php if(empty($topic['Topic']['published'])): ?>
		<span class="label label-danger"><?php echo l_('CHRONOFORUMS_UNPUBLISHED'); ?></span>
		<?php endif; ?>
		<?php if(!empty($topic['Answer']['topic_id'])): ?>
		<span class="label label-success"><?php echo l_('CHRONOFORUMS_ANSWERED'); ?></span>
		<?php endif; ?>
		<?php if(!empty($topic['Topic']['hits']) AND $topic['Topic']['hits'] >= $fparams->get('topic_popular_limit', 30) AND $topic['Topic']['hits']/$days >= $fparams->get('topic_popular_limit', 30)): ?>
		<span class="label label-default" style="background-color:#A901DB;"><?php echo l_('CHRONOFORUMS_POPULAR'); ?></span>
		<?php endif; ?>
		<?php if(!empty($topic['Topic']['post_count']) AND $topic['Topic']['post_count'] >= $fparams->get('topic_hot_limit', 5)): ?>
		<span class="label label-default" style="background-color:#f00;"><?php echo l_('CHRONOFORUMS_HOT'); ?></span>
		<?php endif; ?>
		<?php if(!empty($topic['Topic']['reported'])): ?>
		<span class="label label-warning"><?php echo l_('CHRONOFORUMS_REPORTED'); ?></span>
		<?php endif; ?>
		<?php
	}

	function icon($topic = array(), $user = array()){
		$topic_icon = 'topic';
		if(!empty($topic['Topic']['sticky'])){
			$topic_icon = 'sticky';
		}
		if(!empty($topic['Topic']['announce'])){
			$topic_icon = 'announce';
		}
		$topic_icon .= '_read';
		if(!empty($topic['Topic']['locked'])){
			$topic_icon .= '_locked';
		}
		if($topic['Topic']['user_id'] == $user['id']){
			$topic_icon .= '_mine';
		}
		$topic_icon .= '.gif';
		return $topic_icon;
	}
}