<?php
/**
* ChronoCMS version 1.0
* Copyright (c) 2012 ChronoCMS.com, All rights reserved.
* Author: (ChronoCMS.com Team)
* license: Please read LICENSE.txt
* Visit http://www.ChronoCMS.com for regular updates and information.
**/
namespace GCore\Extensions\Chronoforums\Helpers;
/* @copyright:ChronoEngine.com @license:GPLv2 */defined('_JEXEC') or die('Restricted access');
defined("GCORE_SITE") or die;
class PostEdit {
	var $view;
	
	function display($extra = ''){
		$fparams = $this->view->vars['fparams'];
		$preview = isset($this->view->vars['preview']) ? $this->view->vars['preview'] : false;
		$editor_attachments = isset($this->view->vars['editor_attachments']) ? $this->view->vars['editor_attachments'] : true;
		?>
			<div class="cfu-editor">
				<div class="container">
					<?php
						if(isset($preview) AND $preview === true){
							echo '
								<div class="row cfu-preview">
									<div class="well">
									'.$this->view->Bbcode->parse($this->data['Post']['text']).'
									</div>
								</div>
							';
						}
					?>
					<div class="row">
						<div class="container">
							<div class="row cfu-subject">
								<?php echo $this->view->Html->formSecStart(); ?>
								<?php echo $this->view->Html->formLine('Post[subject]', array('type' => 'text', 'label' => l_('CHRONOFORUMS_SUBJECT'), 'class' => 'XL form-control')); ?>
								<?php echo $this->view->Html->formSecEnd(); ?>
							</div>
							<?php if($extra): ?>
							<?php echo $extra; ?>
							<?php endif; ?>
							<div class="row cfu-message">
								<?php $this->view->Bbeditor->editor(); ?>
							</div>
							<?php echo $this->view->Html->input('f', array('type' => 'hidden', 'value' => \GCore\Libs\Request::data('f'))); ?>
							<?php echo $this->view->Html->input('t', array('type' => 'hidden', 'value' => \GCore\Libs\Request::data('t'))); ?>
							<?php echo $this->view->Html->input('p', array('type' => 'hidden', 'value' => \GCore\Libs\Request::data('p'))); ?>
							<?php if(!isset($editor_attachments) OR $editor_attachments === true): ?>
							<div class="row cfu-upload">
								<?php if(\GCore\Libs\Authorize::authorized('\GCore\Extensions\Chronoforums\Chronoforums', 'attach_files') === true): ?>
									<?php echo $this->view->Html->input('photo', array('type' => 'multi', 'label' => l_('CHRONOFORUMS_ATTACH_FILE'), 'layout' => 'wide',
										'inputs' => array(
											array('type' => 'file', 'class' => 'M', 'name' => 'attach'),
											array('type' => 'submit', 'name' => 'upload', 'value' => l_('CHRONOFORUMS_UPLOAD'), 'style' => 'margin-left:50px;', 'class' => 'btn btn-default')
										)
									)); ?>
								<?php endif; ?>
							</div>
							<?php endif; ?>
							<div class="row cfu-submit">
								<?php echo $this->view->Html->input('buttons', array('type' => 'multi', 'layout' => 'wide',
									'inputs' => array(
										array('type' => 'submit', 'name' => 'cancel_post', 'value' => l_('CHRONOFORUMS_CANCEL'), 'class' => 'btn btn-danger'),
										array('type' => 'submit', 'name' => 'preview', 'value' => l_('CHRONOFORUMS_PREVIEW'), 'class' => 'btn btn-primary'),
										array('type' => 'submit', 'name' => 'submit', 'value' => l_('CHRONOFORUMS_SUBMIT'), 'class' => 'btn btn-success'),
									)
								)); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php
	}
}