<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2013 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.modeladmin');

class EventgalleryModelOrder extends JModelAdmin
{
    protected $text_prefix = 'COM_EVENTGALLERY';

    public function getTable($type = 'order', $prefix = 'Table', $config = array())
    {
        return JTable::getInstance($type, $prefix, $config);
    }

    /**
     * Method to get the record form.
     *
     * @param array $data An optional array of data for the form to interogate.
     * @param boolean $loadData True if the form is to load its own data (default case), false if not.
     * @return JForm A JForm object on success, false on failure
     */
    public function getForm($data = array(), $loadData = true)
    {

        // Get the form.
        $form = $this->loadForm('com_eventgallery.order', 'order', array('control' => 'jform', 'load_data' => $loadData));
        if (empty($form)) {
            return false;
        }
               
        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return mixed The data for the form.
     */
    protected function loadFormData()
    {// Check the session for previously entered form data.
        $data = JFactory::getApplication()->getUserState('com_eventgallery.edit.order.data', array());
        if (empty($data)) {

            $data = $this->getItem()->_getInternalDataObject();
            // Prime some default values.
            if ($this->getState('order.id') == 0) {
                $app = JFactory::getApplication();
                $data['id']= JRequest::getVar('id', $app->getUserState('com_eventgallery.orders.filter.category_id'));
            }
        }
        return $data;
    }

    /**
     * @param string $pk
     * @return bool|mixed|EventgalleryLibraryOrder
     */
    public function getItem($pk = null)
    {
        $pk = (!empty($pk)) ? $pk : $this->getState($this->getName() . '.id');
        $table = $this->getTable();

        if ($pk > 0)
        {
            // Attempt to load the row.
            $return = $table->load($pk);

            // Check for a table object error.
            if ($return === false && $table->getError())
            {
                $this->setError($table->getError());
                return false;
            }
        }

        // Convert to the JObject before adding other data.
        $properties = $table->getProperties(1);
        $item = JArrayHelper::toObject($properties, 'JObject');

        if (property_exists($item, 'params'))
        {
            $registry = new JRegistry;
            $registry->loadString($item->params);
            $item->params = $registry->toArray();
        }



        return new EventgalleryLibraryOrder($item->id);

    }

    protected function populateState()
    {
        $table = $this->getTable();
        $key = $table->getKeyName();

        // Get the pk of the record from the request.
        $pk = JFactory::getApplication()->input->getString($key);
        $this->setState($this->getName() . '.id', $pk);

        // Load the parameters.
        $value = JComponentHelper::getParams($this->option);
        $this->setState('params', $value);
    }

    /**
     * Method to save the form data.
     *
     * @param   array  $data  The form data.
     *
     * @return  boolean  True on success, False on error.
     *
     * @since   12.2
     */
    public function save($data)
    {
        #$dispatcher = JEventDispatcher::getInstance();
        $table = $this->getTable();

        $key = $table->getKeyName();
        $pk = (!empty($data[$key])) ? $data[$key] : $this->getState($this->getName() . '.id');
        $isNew = true;

        // Include the content plugins for the on save events.
        JPluginHelper::importPlugin('content');

        // Allow an exception to be thrown.
        try
        {
            // Load the row if saving an existing record.
            if ($pk > 0)
            {
                $table->load($pk);
                $isNew = false;
            }

            // Bind the data.
            if (!$table->bind($data))
            {
                $this->setError($table->getError());
                return false;
            }

            // Prepare the row for saving
            $this->prepareTable($table);

            // Check the data.
            if (!$table->check())
            {
                $this->setError($table->getError());
                return false;
            }

            // Trigger the onContentBeforeSave event.
            # $result = $dispatcher->trigger($this->event_before_save, array($this->option . '.' . $this->name, $table, $isNew));
            if (in_array(false, $result, true))
            {
                $this->setError($table->getError());
                return false;
            }

            // Store the data.
            if (!$table->store())
            {
                $this->setError($table->getError());
                return false;
            }

            // Clean the cache.
            $this->cleanCache();

            // Trigger the onContentAfterSave event.
            #$dispatcher->trigger($this->event_after_save, array($this->option . '.' . $this->name, $table, $isNew));
        }
        catch (Exception $e)
        {
            $this->setError($e->getMessage());

            return false;
        }

        $pkName = $table->getKeyName();

        if (isset($table->$pkName))
        {
            $this->setState($this->getName() . '.id', $table->$pkName);
        }
        $this->setState($this->getName() . '.new', $isNew);

        return true;
    }

    public function delete(&$pks) {
        $result = parent::delete($pks);

        $pks = (array) $pks;
        $table = $this->getTable();

        // Iterate the items to delete each one.
        foreach ($pks as $i => $pk)
        {
            // if the order was deleted, remote the line items too.
            if (!$table->load($pk))
            {
                // remove lineitems
                $db = JFactory::getDBO();
                $query = $db->getQuery(true)
                    ->delete($db->quoteName('#__eventgallery_imagelineitem'))
                    ->where('lineitemcontainerid=' . $db->quote($pk));
                $db->setQuery($query);
                $db->query();

                //remove servicelineitems
                $db = JFactory::getDBO();
                $query = $db->getQuery(true)
                    ->delete($db->quoteName('#__eventgallery_servicelineitem'))
                    ->where('lineitemcontainerid=' . $db->quote($pk));
                $db->setQuery($query);
                $db->query();
            }
        }

        return $result;
    }

}
