<?php
/**
* COMPONENT FILE HEADER
**/
namespace GCore\Admin\Extensions\Chronoforums\Controllers;
/* @copyright:ChronoEngine.com @license:GPLv2 */defined('_JEXEC') or die('Restricted access');
defined("GCORE_SITE") or die;
class Installer extends \GCore\Libs\GController {
	function index(){
		//apply updates
		$sql = file_get_contents(\GCore\C::ext_path('chronoforums', 'admin').'sql'.DS.'install.chronoforums.sql');
		
		$queries = \GCore\Libs\Database::getInstance()->split_sql($sql);
		foreach($queries as $query){
			\GCore\Libs\Database::getInstance()->exec(\GCore\Libs\Database::getInstance()->_prefixTable($query));
		}
		
		$session = \GCore\Libs\Base::getSession();
		$session->setFlash('success', l_('CF_DB_TABLES_INSTALLED'));
		$this->redirect(r_('index.php?ext=chronoforums'));
	}
	
	function fix_charset(){
		$posts = \GCore\Admin\Extensions\Chronoforums\Models\Post::getInstance()->find('all', array('recursive' => -1));
		foreach($posts as $post){
			$data = array(
				'id' => $post['Post']['id'], 
				'subject' => mb_convert_encoding($post['Post']['subject'], 'ISO-8859-1', 'UTF-8'), 
				'text' => mb_convert_encoding($post['Post']['text'], 'ISO-8859-1', 'UTF-8'), 
			);
			\GCore\Admin\Extensions\Chronoforums\Models\Post::getInstance()->save($data);
		}
		
		$topics = \GCore\Admin\Extensions\Chronoforums\Models\Topic::getInstance()->find('all', array('recursive' => -1));
		foreach($topics as $topic){
			$data = array(
				'id' => $topic['Topic']['id'], 
				'title' => mb_convert_encoding($topic['Topic']['title'], 'ISO-8859-1', 'UTF-8'), 
				'alias' => '', 
			);
			\GCore\Admin\Extensions\Chronoforums\Models\Topic::getInstance()->save($data);
		}
		echo "Done!";
	}
}
?>